import * as tslib_1 from "tslib";
import { WebPlugin } from "@capacitor/core";
var _a = require('electron'), clipboard = _a.clipboard, nativeImage = _a.nativeImage;
var ClipboardPluginElectron = /** @class */ (function (_super) {
    tslib_1.__extends(ClipboardPluginElectron, _super);
    function ClipboardPluginElectron() {
        return _super.call(this, {
            name: 'Clipboard',
            platforms: ['electron']
        }) || this;
    }
    ClipboardPluginElectron.prototype.write = function (options) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                return [2 /*return*/, new Promise(function (resolve) {
                        if (options.string) {
                            clipboard.writeText(options.string);
                        }
                        else if (options.url) {
                            clipboard.write({
                                text: options.url,
                                bookmark: options.label || ''
                            });
                        }
                        else if (options.image) {
                            var dataURL = options.image;
                            clipboard.write({
                                image: nativeImage.createFromDataURL(dataURL)
                            });
                        }
                        return resolve();
                    })];
            });
        });
    };
    ClipboardPluginElectron.prototype.read = function (_options) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                return [2 /*return*/, new Promise(function (resolve, reject) {
                        var availableFormats = clipboard.availableFormats();
                        for (var _i = 0, availableFormats_1 = availableFormats; _i < availableFormats_1.length; _i++) {
                            var format = availableFormats_1[_i];
                            if (format === "text/plain") {
                                return resolve({ "value": clipboard.readText() });
                            }
                            else if (format === "text/html") {
                                return resolve({ "value": clipboard.readHTML() });
                            }
                            else if (format === "image/png" || format === "image/jpeg") {
                                return resolve({ "value": clipboard.readImage().toDataURL() });
                            }
                        }
                        return reject('Unable to get data from clipboard');
                    })];
            });
        });
    };
    return ClipboardPluginElectron;
}(WebPlugin));
export { ClipboardPluginElectron };
var Clipboard = new ClipboardPluginElectron();
export { Clipboard };
//# sourceMappingURL=clipboard.js.map