import * as tslib_1 from "tslib";
import { WebPlugin, FilesystemDirectory, } from "@capacitor/core";
var FilesystemPluginElectron = /** @class */ (function (_super) {
    tslib_1.__extends(FilesystemPluginElectron, _super);
    function FilesystemPluginElectron() {
        var _this = _super.call(this, {
            name: 'Filesystem',
            platforms: ['electron']
        }) || this;
        _this.NodeFS = null;
        _this.fileLocations = null;
        _this.fileLocations = { DRIVE_ROOT: '', DOCUMENTS: '' };
        var path = require("path");
        var os = require("os");
        if (os.platform == "win32") {
            _this.fileLocations["DRIVE_ROOT"] = process.cwd().split(path.sep)[0];
        }
        else {
            _this.fileLocations["DRIVE_ROOT"] = '/';
        }
        _this.fileLocations[FilesystemDirectory.Documents] = path.join(os.homedir(), "Documents") + path.sep;
        _this.NodeFS = require('fs');
        return _this;
    }
    FilesystemPluginElectron.prototype.readFile = function (options) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            if (Object.keys(_this.fileLocations).indexOf(options.directory) === -1)
                reject(options.directory + " is currently not supported in the Electron implementation.");
            var lookupPath = _this.fileLocations[options.directory] + options.path;
            _this.NodeFS.readFile(lookupPath, options.encoding, function (err, data) {
                if (err)
                    reject(err);
                resolve({ data: data });
            });
        });
    };
    FilesystemPluginElectron.prototype.writeFile = function (options) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            if (Object.keys(_this.fileLocations).indexOf(options.directory) === -1)
                reject(options.directory + " is currently not supported in the Electron implementation.");
            var lookupPath = _this.fileLocations[options.directory] + options.path;
            _this.NodeFS.writeFile(lookupPath, options.data, options.encoding, function (err) {
                if (err)
                    reject(err);
                resolve();
            });
        });
    };
    FilesystemPluginElectron.prototype.appendFile = function (options) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            if (Object.keys(_this.fileLocations).indexOf(options.directory) === -1)
                reject(options.directory + " is currently not supported in the Electron implementation.");
            var lookupPath = _this.fileLocations[options.directory] + options.path;
            _this.NodeFS.appendFile(lookupPath, options.encoding, options.data, function (err) {
                if (err)
                    reject(err);
                resolve();
            });
        });
    };
    FilesystemPluginElectron.prototype.deleteFile = function (options) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            if (Object.keys(_this.fileLocations).indexOf(options.directory) === -1)
                reject(options.directory + " directory is currently not supported in the Electron implementation.");
            var lookupPath = _this.fileLocations[options.directory] + options.path;
            _this.NodeFS.unlink(lookupPath, function (err) {
                if (err)
                    reject(err);
                resolve();
            });
        });
    };
    FilesystemPluginElectron.prototype.mkdir = function (options) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            if (Object.keys(_this.fileLocations).indexOf(options.directory) === -1)
                reject(options.directory + " is currently not supported in the Electron implementation.");
            var lookupPath = _this.fileLocations[options.directory] + options.path;
            _this.NodeFS.mkdir(lookupPath, function (err) {
                if (err)
                    reject(err);
                resolve();
            });
        });
    };
    // TODO: continue bring to spec.
    FilesystemPluginElectron.prototype.rmdir = function (options) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            _this.NodeFS.rmdir(options.path, function (err) {
                if (err)
                    reject(err);
                resolve();
            });
        });
    };
    FilesystemPluginElectron.prototype.readdir = function (options) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            var opts = { path: options.path, encoding: 'utf-8' };
            _this.NodeFS.readdir(opts.path, opts.encoding, function (err, files) {
                if (err)
                    reject(err);
                resolve({ files: files });
            });
        });
    };
    FilesystemPluginElectron.prototype.getUri = function (options) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            if (Object.keys(_this.fileLocations).indexOf(options.directory) === -1)
                reject(options.directory + " directory is currently not supported in the Electron implementation.");
            var lookupPath = _this.fileLocations[options.directory] + options.path;
            resolve({ uri: lookupPath });
        });
    };
    ;
    FilesystemPluginElectron.prototype.stat = function (options) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            if (Object.keys(_this.fileLocations).indexOf(options.directory) === -1)
                reject(options.directory + " is currently not supported in the Electron implementation.");
            var lookupPath = _this.fileLocations[options.directory] + options.path;
            _this.NodeFS.stat(options.path, function (err, stats) {
                if (err)
                    reject(err);
                resolve({ type: 'Not Available', size: stats.size, ctime: stats.ctimeMs, mtime: stats.mtimeMs, uri: lookupPath });
            });
        });
    };
    return FilesystemPluginElectron;
}(WebPlugin));
export { FilesystemPluginElectron };
var Filesystem = new FilesystemPluginElectron();
export { Filesystem };
//# sourceMappingURL=filesystem.js.map