import * as tslib_1 from "tslib";
import { WebPlugin } from "@capacitor/core";
var _a = require('electron').remote, dialog = _a.dialog, getCurrentWindow = _a.getCurrentWindow;
var ModalsPluginElectron = /** @class */ (function (_super) {
    tslib_1.__extends(ModalsPluginElectron, _super);
    function ModalsPluginElectron() {
        return _super.call(this, {
            name: 'Modals',
            platforms: ['electron']
        }) || this;
    }
    ModalsPluginElectron.prototype.alert = function (options) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var alert;
            return tslib_1.__generator(this, function (_a) {
                alert = function (message, title) {
                    if (title === void 0) { title = ''; }
                    var buttons = [options.buttonTitle || 'OK'];
                    dialog.showMessageBox(getCurrentWindow(), { message: message, title: title, buttons: buttons });
                };
                alert(options.message, options.title);
                return [2 /*return*/, Promise.resolve()];
            });
        });
    };
    ModalsPluginElectron.prototype.prompt = function (options) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var val;
            return tslib_1.__generator(this, function (_a) {
                val = window.prompt(options.message, options.inputPlaceholder || '');
                return [2 /*return*/, Promise.resolve({
                        value: val,
                        cancelled: val === null
                    })];
            });
        });
    };
    ModalsPluginElectron.prototype.confirm = function (options) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var confirm, val;
            return tslib_1.__generator(this, function (_a) {
                confirm = function (message, title) {
                    if (title === void 0) { title = ''; }
                    var buttons = [options.okButtonTitle || 'OK', options.cancelButtonTitle || 'Cancel'];
                    return !dialog.showMessageBox(getCurrentWindow(), { message: message, title: title, buttons: buttons });
                };
                val = confirm(options.message, options.title);
                return [2 /*return*/, Promise.resolve({
                        value: val
                    })];
            });
        });
    };
    ModalsPluginElectron.prototype.showActions = function (options) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var _this = this;
            return tslib_1.__generator(this, function (_a) {
                return [2 /*return*/, new Promise(function (resolve, _reject) { return tslib_1.__awaiter(_this, void 0, void 0, function () {
                        var controller, items, actionSheetElement;
                        return tslib_1.__generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    controller = document.querySelector('ion-action-sheet-controller');
                                    if (!controller) {
                                        controller = document.createElement('ion-action-sheet-controller');
                                        document.body.appendChild(controller);
                                    }
                                    return [4 /*yield*/, controller.componentOnReady()];
                                case 1:
                                    _a.sent();
                                    items = options.options.map(function (o, i) {
                                        return {
                                            text: o.title,
                                            role: o.style && o.style.toLowerCase() || '',
                                            icon: o.icon || '',
                                            handler: function () {
                                                resolve({
                                                    index: i
                                                });
                                            }
                                        };
                                    });
                                    return [4 /*yield*/, controller.create({
                                            title: options.title,
                                            buttons: items
                                        })];
                                case 2:
                                    actionSheetElement = _a.sent();
                                    return [4 /*yield*/, actionSheetElement.present()];
                                case 3:
                                    _a.sent();
                                    return [2 /*return*/];
                            }
                        });
                    }); })];
            });
        });
    };
    return ModalsPluginElectron;
}(WebPlugin));
export { ModalsPluginElectron };
var Modals = new ModalsPluginElectron();
export { Modals };
//# sourceMappingURL=modals.js.map