import * as tslib_1 from "tslib";
import { WebPlugin } from '@capacitor/core';
var NetworkPluginElectron = /** @class */ (function (_super) {
    tslib_1.__extends(NetworkPluginElectron, _super);
    function NetworkPluginElectron() {
        var _this = _super.call(this, {
            name: 'Network',
            platforms: ['electron']
        }) || this;
        _this.listenerFunction = null;
        return _this;
    }
    NetworkPluginElectron.prototype.getStatus = function () {
        return new Promise(function (resolve, reject) {
            if (!window.navigator) {
                reject('Network info not available');
                return;
            }
            var connected = window.navigator.onLine;
            var connection = window.navigator.connection || window.navigator.mozConnection || window.navigator.webkitConnection;
            var connectionType = 'wifi';
            if (connection) {
                connectionType = connection.type;
            }
            resolve({
                connected: connected,
                connectionType: connected ? connectionType : 'none'
            });
        });
    };
    NetworkPluginElectron.prototype.addListener = function (eventName, listenerFunc) {
        var thisRef = this;
        var connection = window.navigator.connection || window.navigator.mozConnection || window.navigator.webkitConnection;
        var connectionType = 'wifi';
        if (connection) {
            connectionType = connection.type;
        }
        var onlineBindFunc = listenerFunc.bind(thisRef, { connected: true, connectionType: connectionType });
        var offlineBindFunc = listenerFunc.bind(thisRef, { connected: false, connectionType: 'none' });
        if (eventName.localeCompare('networkStatusChange') === 0) {
            window.addEventListener('online', onlineBindFunc);
            window.addEventListener('offline', offlineBindFunc);
            return {
                remove: function () {
                    window.removeEventListener('online', onlineBindFunc);
                    window.removeEventListener('offline', offlineBindFunc);
                }
            };
        }
    };
    return NetworkPluginElectron;
}(WebPlugin));
export { NetworkPluginElectron };
var Network = new NetworkPluginElectron();
export { Network };
//# sourceMappingURL=network.js.map