var CapacitorElectron = /** @class */ (function () {
    function CapacitorElectron() {
        var _this = this;
        this.Plugins = {};
        this.platform = 'electron';
        this.isNative = false;
        // Build a proxy for the Plugins object that returns the "Noop Plugin"
        // if a plugin isn't available
        this.Plugins = new Proxy(this.Plugins, {
            get: function (target, prop) {
                if (typeof target[prop] === 'undefined') {
                    var thisRef_1 = _this;
                    return new Proxy({}, {
                        get: function (_target, _prop) {
                            if (typeof _target[_prop] === 'undefined') {
                                return thisRef_1.pluginMethodNoop.bind(thisRef_1, _target, _prop, prop);
                            }
                            else {
                                return _target[_prop];
                            }
                        }
                    });
                }
                else {
                    return target[prop];
                }
            }
        });
    }
    CapacitorElectron.prototype.pluginMethodNoop = function (_target, _prop, pluginName) {
        return Promise.reject(pluginName + " does not have web implementation.");
    };
    CapacitorElectron.prototype.getPlatform = function () {
        return this.platform;
    };
    CapacitorElectron.prototype.isPluginAvailable = function (name) {
        return this.Plugins.hasOwnProperty(name);
    };
    CapacitorElectron.prototype.handleError = function (e) {
        console.error(e);
    };
    return CapacitorElectron;
}());
export { CapacitorElectron };
//# sourceMappingURL=runtime.js.map